<?php
$configData = Helper::applClasses();
$rol = auth()->user()->id_account_type;
$expiration_date = auth()->user()->expiration_date;
?>
<div class="main-menu menu-fixed <?php echo e(($configData['theme'] === 'dark') ? 'menu-dark' : 'menu-light'); ?> menu-accordion menu-shadow" data-scroll-to-active="true">
    <div class="navbar-header">
        <ul class="nav navbar-nav flex-row">
            <li class="nav-item mr-auto">
                <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                    <span class="brand-logo">
                        <img src="<?php echo e(asset('images/logo/promolider_logo.png')); ?>" style="margin-left: 40px; min-width: 130px;width:100%">
                    </span>
                    <!-- <h2 class="brand-text">Promolider</h2> -->
                </a>
            </li>
        </ul>
    </div>
    <div></div>
    <div class="main-menu-content">
        <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
            
            <?php if(isset($menuData[0])): ?>
            <?php $__currentLoopData = $menuData[0]->menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(isset($menu->navheader)): ?>
            <li class="navigation-header">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check($menu->slug)): ?>
                <span><?php echo e(__('locale.'.$menu->navheader)); ?></span>
                <i data-feather="more-horizontal"></i>
                <?php endif; ?>
            </li>
            <?php else: ?>
            
            <?php
            $custom_classes = "";
            if(isset($menu->classlist)) {
            $custom_classes = $menu->classlist;
            }
            ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check($menu->slug)): ?>
            <li class="nav-item <?php echo e(Route::currentRouteName() === $menu->slug ? 'active' : ''); ?> <?php echo e($custom_classes); ?>">
                <a href="<?php echo e(isset($menu->url)? url($menu->url):'javascript:void(0)'); ?>" class="d-flex align-items-center" target="<?php echo e(isset($menu->newTab) ? '_blank':'_self'); ?>">
                    <i data-feather="<?php echo e($menu->icon); ?>"></i>
                    <span class="menu-title text-truncate"><?php echo e(__('locale.'.$menu->name)); ?></span>
                    <?php if(isset($menu->badge)): ?>
                    <?php $badgeClasses = "badge badge-pill badge-light-primary ml-auto mr-1" ?>
                    <span class="<?php echo e(isset($menu->badgeClass) ? $menu->badgeClass : $badgeClasses); ?> "><?php echo e($menu->badge); ?></span>
                    <?php endif; ?>
                </a>
                <?php if(isset($menu->submenu)): ?>
                <?php echo $__env->make('panels/submenu', ['menu' => $menu->submenu], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if($rol != 1 && $rol != 5 && $rol != 6): ?>
            <div class="px-3 mt-5">
                <div id="countdown" class="btn btn-primary d-flex justify-content-center">Recomprar OPC</div>
            </div>
            <?php endif; ?>
            <?php endif; ?>

            
        </ul>

    </div>

</div>

<div id="modal-countdown" class="modal fade modal-primary" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <slot name="title">Expiración de OPC</slot>
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <slot name="body">
                    <p>Tiempo restante para la expiración de su estado activo</p>
                    <div class="row ml-1">
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="days">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Días</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="hours">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Horas</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="minutes">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Minutos</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="seconds">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Segundos</p>
                            </div>
                        </div>
                    </div>
                </slot>

                <form style="display:none;" id="payment_method_form" class="mt-2">
                    <div id="payment_method_selector" class="form-group col-12 col-lg-6">
                        <label for="payment_method_id">Seleccione el método de pago</label>
                        <select id="payment_method_id" name="payment_method_id" class="form-control">
                        </select>
                        <div id="payment_method_id_error" class="invalid-feedback"></div>
                    </div>
                </form>
                <p id="message_conditions" style="display: none;">
                    Al hacer click en "Comprar" usted está aceptando nuestros <button type="button" class="btn btn-link" onclick="showConditions()">términos y condiciones.</button>
                </p>
            </div>
            <div class="modal-footer">
                <slot name="footer">
                    <button class="btn btn-warning" onclick="hideForm()" id="cancel" style="display: none;">Cancelar</button>
                    <button class="btn btn-primary" onclick="payOPC()" id="continue" style="display: none;" type="button">Comprar</button>
                    <button class="btn btn-primary" onclick="showForm()" id="buy">Recompra</button>

                </slot>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_conditions" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document" style="overflow-y: initial !important">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-success" id="exampleModalLabel">Términos y condiciones</h5>
        </div>
        <div class="modal-body overflow-auto">
            <?php echo $__env->make('modalOpenpayConditions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-primary" onclick="hideConditions()" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
</div>
<!-- END: Main Menu-->
<?php if($rol != 1 && $rol != 5 && $rol != 6): ?>
<script>
    const select_payment_method = document.getElementById("payment_method_id");

    let form = document.getElementById("payment_method_form");
    let cancel_button = document.getElementById("cancel");
    let buy_button = document.getElementById("buy");
    let continue_button = document.getElementById("continue");
    let message_conditions = document.getElementById("message_conditions");
    let modal_conditions = document.getElementById("modal_conditions");
    let modal_countdown = document.getElementById("modal-countdown");

    async function showForm() {
        const response = await fetch('/config/payment-method/list-array');
        const data = await response.json();

        select_payment_method.innerHTML = "";

        data.forEach(function(item) {
            const optionObj = document.createElement("option");
            optionObj.textContent = item.name;
            optionObj.value = item.id;
            select_payment_method.appendChild(optionObj);
        });

        form.style.display = "block";
        cancel_button.style.display = "block";
        continue_button.style.display = "block";
        buy_button.style.display = "none";
        message_conditions.style.display = "block";
    }

    function hideForm() {
        form.style.display = "none";
        continue_button.style.display = "none";
        cancel_button.style.display = "none";
        buy_button.style.display = "block";
        message_conditions.style.display = "none";
    }

    function showConditions(){
        $('#modal_conditions').modal({ show:true });
        $("#modal_conditions").addClass("overflow-auto");
        $('#modal-countdown').modal('hide')
    }

    function hideConditions(){
        $('#modal_conditions').modal('hide');
        $('#modal-countdown').modal({ show:true });
    }

    async function payOPC() {

        let value = await select_payment_method.options[select_payment_method.selectedIndex].value;

        switch (value) {
            case '1':
                window.location.href = "/pay/opc-openpay";
                break;
            case '2':

                break;
            case '3':

                break;
            case '4':
                window.location.href = "/pay/recompra";
                break;

            default:
                break;
        }
        // direccionar de acuerdo al metodo de pago
    }

    let expiration_date = new Date();
    <?php echo "expiration_date = '$expiration_date';" ?>
    let date_target = new Date(expiration_date);
    let countdown = document.getElementById("countdown");

    countdown.addEventListener("click", function() {
        evaluateTime(date_target);
        let x = setInterval(function() {
            let distance = evaluateTime(date_target);
            if (distance < 0) {
                clearInterval(x);
            }
        }, 1000);
        $('#modal-countdown').modal('show');
        $("#modal-countdown").on('hidden.bs.modal', function() {
            clearInterval(x);
        });
    });

    function evaluateTime(date_target) {
        let now = new Date().getTime();
        let distance = date_target - now;
        let days = Math.floor(distance / (1000 * 60 * 60 * 24));
        let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        let seconds = Math.floor((distance % (1000 * 60)) / 1000);
        days = addZero(days);
        hours = addZero(hours);
        minutes = addZero(minutes);
        seconds = addZero(seconds);

        if (distance < 0) {
            days = "00";
            hours = "00";
            minutes = "00";
            seconds = "00"
        }
        $('#days').html(days);
        $('#hours').html(hours);
        $('#minutes').html(minutes);
        $('#seconds').html(seconds);
        return distance;
    }

    function addZero(num) {
        if (num <= 9) {
            return num = "0" + num;
        } else {
            return num;
        }
    }
</script>
<?php endif; ?><?php /**PATH /home/promolider/public_html/crm/resources/views/panels/sidebar.blade.php ENDPATH**/ ?>