@extends('adminlte::page')
@section('title', 'Ipssoma / Dashboard')

@section('content_header')
    {{-- google ads --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-11111928634"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'AW-11111928634');
    </script>
    {{-- google analytics --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-C4PSP030TR"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-C4PSP030TR');
    </script>
@stop
@section('content')
    <div id="app">
        <div>
            <strong>Nuevo vendedor</strong>
        </div>
        <div>
            <form action="{{route('vendedor.guardar')}}" method="post">
                @csrf
                <div class="mb-3">
                  <label for="" class="form-label">Nombres</label>
                  <div>
                      <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror">
                      @error('name')
                      <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                  </div>
                </div>
                <div class="mb-3">
                  <label for="" class="form-label">Correo</label>
                  <div>
                      <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror">
                      @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                  </div>
                </div>
                <div class="mb-3">
                  <label for="" class="form-label">Contraseña</label>
                  <div>
                      <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror">
                      @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                  </div>
                </div>
                <div class="mb-3">
                  <label for="" class="form-label">Verificar contraseña</label>
                  <div>
                      <input type="password" name="password_confirmation" id="confirm_password" class="form-control @error('password') is-invalid @enderror">
                  </div>
                </div>
                <div class="mb-3">
                    <label for="phone" class="">Teléfono</label>

                    <div class="">
                        <input id="phone" type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}">

                        @error('phone')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                <div class="mb-3">
                    <div class="">
                        <strong>Tipo de documento</strong>
                        <select class="form-control" name="type_doc">
                            @foreach ($documents as $document)
                                <option value="{{$document->id}}">{{$document->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="number_doc" class="">Nro. de documento</label>

                    <div class="">
                        <input id="number_doc" type="text" class="form-control @error('number_doc') is-invalid @enderror" name="number_doc" value="{{ old('number_doc') }}">
                        @error('number_doc')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                {{-- <div class="mb-3">
                    <label for="birthday" class="">Fecha de nacimiento</label>

                    <div class="">
                        <input id="birthday" type="date" class="form-control @error('birthday') is-invalid @enderror" name="birthday" value="{{ old('birthday') }}">

                        @error('birthday')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div> --}}



                <button type="submit" class="btn btn-primary">Guardar</button>
            </form>
        
        </div>

    </div>
@stop

@section('css')
<link href="{{ asset('css/app.css') }}" rel="stylesheet">
<style>
    .alert {
        line-height: 40%;
    }
</style>
@stop

@section('js')
<script src="{{asset('js/app.js')}}">

</script>
@stop