<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <!-- Google / Search Engine Tags -->
    <meta itemprop="name" content="Bienvenido al Instituto SSOMA">
    <meta itemprop="description" content="Ingresa a este enlace para empezar tu registro">
    <meta itemprop="image" content="https://ipssoma-storage.s3.eu-west-1.amazonaws.com/static/ipssomaIcono.png">

    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Bienvenido al Instituto SSOMA">
    <meta property="og:description" content="Ingresa a este enlace para empezar tu registro">
    <meta property="og:image" content="https://ipssoma-storage.s3.eu-west-1.amazonaws.com/static/ipssomaIcono.png">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Bienvenido al Instituto SSOMA">
    <meta name="twitter:description" content="Ingresa a este enlace para empezar tu registro">
    <meta name="twitter:image" content="https://ipssoma-storage.s3.eu-west-1.amazonaws.com/static/ipssomaIcono.png">

    <link rel="stylesheet" href="{{asset('css/app.css')}}">
    <title>Document</title>
</head>
<body>
    <div class="container-fluid p-2">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 m-auto">
                <div class="card">

                    <div class="container mt-4">

                    <div class="card-body">
                        <h4 class="text-center mb-4">Register</h4>

                        <!-- formulario de registro -->
                            <form method="POST" action="{{ route('usuario.registrar') }}">
                                @csrf

                                <div class="form-group row mb-2">
                                    <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Name') }}</label>

                                    <div class="col-md-6">
                                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" autofocus>

                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-2">
                                    <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                                    <div class="col-md-6">
                                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}">

                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-2">
                                    <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>

                                    <div class="col-md-6">
                                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-2">
                                    <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                                    <div class="col-md-6">
                                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation">
                                    </div>
                                </div>
                               {{-- phone --}}
                                <div class="form-group row mb-2">
                                    <label for="phone" class="col-md-4 col-form-label text-md-right">{{ __('Phone') }}</label>

                                    <div class="col-md-6">
                                        <input id="phone" type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}">

                                        @error('phone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                {{--type_doc - select --}}
                                <div class="form-group row mb-2">

                                    <label for=""class="col-md-4 col-form-label text-md-right" >Type document</label>
                                    <div class="col-md-6">
                                        <select class="form-control" name="doc_type_id">
                                            @foreach ($documents as $document)
                                                <option value="{{$document->id}}">{{$document->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                {{--number_doc--}}
                                <div class="form-group row mb-2">
                                    <label for="number_doc" class="col-md-4 col-form-label text-md-right">{{ __('Number Document') }}</label>

                                    <div class="col-md-6">
                                        <input id="number_doc" type="text" class="form-control @error('number_doc') is-invalid @enderror" name="number_doc" value="{{ old('number_doc') }}">
                                        @error('number_doc')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                {{-- country  - select --}}
                                <div class="form-group row mb-2">

                                       <label for="" class="col-md-4 col-form-label text-md-right">Country</label>
                                    <div class="col-md-6">
                                        <select class="form-control" name="country">
                                            @foreach ($country as $count )
                                            <option value="{{$count->id}}">{{$count->name}}</option>

                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                {{-- birthday --}}
                                <div class="form-group row mb-2">
                                    <label for="birthday" class="col-md-4 col-form-label text-md-right">{{ __('Birthdate') }}</label>

                                    <div class="col-md-6">
                                        <input id="birthday" type="date" class="form-control @error('birthday') is-invalid @enderror" name="birthday" value="{{ old('birthday') }}">

                                        @error('birthday')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                {{-- course - select --}}
                                <div class="form-group row mb-2">

                                    <label for="" class="col-md-4 col-form-label text-md-right">Course</label>
                                    <div class="col-md-6">
                                        <select class="form-control" name="course_id">
                                            @foreach ($prod as $product )
                                            <option value="{{$product->id}}">{{$product->nombre}}</option>

                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                {{--  --}}
                                <input type="hidden" name="seller_id" value="{{$id}}">
                                <div class="form-group">
                                    <div class="text-center py-3">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Register') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        <!-- formulario de registro -->

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{asset('js/app.js?v=345443')}}"></script>
</body>
</html>
