<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OperationalControlSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $elimination =  "Evaluar si es posible sustituir el producto químico peligroso por uno menos tóxico o eliminar por completo su uso en el proceso de ensamblaje.";
        $sustitution = "En caso de no ser posible la eliminación, considerar la sustitución del producto químico por uno menos peligroso para reducir el riesgo de intoxicación por inhalación.";
        $engineering_control = "Implementar sistemas de ventilación adecuados en la oficina principal para minimizar la concentración de gases tóxicos en el ambiente de trabajo.";
        $admin_control = "Establecer protocolos de seguridad y capacitación para el manejo adecuado de productos químicos, así como para la respuesta ante emergencias por intoxicación.";
        $epps = "Proporcionar al técnico que realiza la actividad de atención al cliente en la oficina principal equipo de protección personal como mascarillas respiratorias adecuadas para protegerse de la inhalación de gases tóxicos.";

        DB::table('operational_control')->insert([
            'iperc_id' => 1,
            'elimination' => $elimination,
            'sustitution' => $sustitution,
            'engineering_control' => $engineering_control,
            'admin_control' => $admin_control,
            'epps' => $epps,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
