<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIpercTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('iperc', function (Blueprint $table) {
            $table->id();
            $table->foreignId('matrix_id')->constrained('matrix')->onUpdate('cascade')->onDelete('cascade')->after('consequences_id');
            $table->foreignId('places_id')->constrained('places')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('processes_id')->constrained('processes')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('tasks_id')->constrained('tasks')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('work_positions_id')->constrained('work_positions')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('risks_id')->constrained('risks')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('dangers_id')->constrained('dangers')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('consequences_id')->constrained('consequences')->onUpdate('cascade')->onDelete('cascade');
            $table->string('type',60);
            $table->enum('routine',['Y','N']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('iperc');
    }
}
