<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('exams', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('course_id')->unsigned();
            $table->bigInteger('module_id')->unsigned()->nullable();
            $table->bigInteger('lesson_id')->unsigned()->nullable();
            $table->string('title');
            $table->bigInteger('time')->nullable();
            $table->tinyInteger('status');
            $table->integer('max_score');
            $table->double('min_passing_score');
            $table->timestamps();

            $table->foreign('course_id')->references('id')->on('productos')
                ->onDelete('cascade');
            $table->foreign('module_id')->references('id')->on('modules')
                ->onDelete('cascade');
            $table->foreign('lesson_id')->references('id')->on('class')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exams');
    }
}
