<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIsosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('isos', function (Blueprint $table) {
            $table->id();
            $table->string('name',100);
            $table->longText('intro')->nullable();
            $table->longText('time_obtaining')->nullable();
            $table->longText('time_validity')->nullable();
            $table->longText('steps_implementation')->nullable();
            $table->longText('benefits')->nullable();
            $table->text('url_image_cover')->nullable();
            $table->string('cover_name',100)->nullable();
            $table->text('url_image_page')->nullable();
            $table->string('page_name',100)->nullable();
            $table->timestamps();    
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('isos');
    }
}
