<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Auth;
use App\Models\User;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        $this->register();

        Gate::define('gateAdmin', function ($users) {
            if ($users->roles_id == '1') {
                return true;
            }
            return false;
        });
        Gate::define('gateVendedores', function ($users) {
            if ($users->roles_id == '3') {
                return true;
            }
            return false;
        });

        Gate::define('gateModulos', function ($users) {

            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para llevar el control de pagos pendientes de los clientes
            $permiso = '4';

            if ($user->permissions != null) {
                return true;
            } else {
                return false;
            }
        });

        Gate::define('gateClientesCertificados', function ($users) {

            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para crear nuevos clientes certificados 
            $permiso = '1';

            if (strlen(strstr($user->permissions, $permiso)) > 0) {
                return true;
            } else {
                return false;
            }
        });

        Gate::define('gateClientes_sst', function ($users) {

            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para crear nuevos clientes certificados 
            $permiso = '2';

            if (strlen(strstr($user->permissions, $permiso)) > 0) {
                return true;
            } else {
                return false;
            }
        });

        Gate::define('gateCertificados', function ($users) {

            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para crear nuevos clientes certificados 
            $permiso = '3';

            if (strlen(strstr($user->permissions, $permiso)) > 0) {
                return true;
            } else {
                return false;
            }
        });

        Gate::define('gatePagosPendientes', function ($users) {
            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para llevar el control de pagos pendientes de los clientes
            $permiso = '4';

            if (strlen(strstr($user->permissions, $permiso)) > 0) {
                return true;
            } else {
                return false;
            }
        });
        Gate::define('gateAlerts', function ($users) {
            //obtenemos el id con auth de forma dinamica
            $auth_id = auth::user()->id;
            //separamos el id para las siguientes validaciones
            $user = User::find($auth_id);
            //Permiso para llevar el control de pagos pendientes de los clientes
            $permiso = '4';

            if (strlen(strstr($user->permissions, $permiso)) > 0) {
                return true;
            } else {
                return false;
            }
        });

        Gate::define('gateRedactor', function ($users) {
            if ($users->roles_id == '5') {
                return true;
            }
            return false;
        });

        Gate::define('gateSubAdmin', function($users){
            if ($users->roles_id == '6') {
                return true;
            }
            return false;
        });
    }
}
