<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Risk;
use App\Http\Controllers\Controller;

class RiskController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $risks = Risk::all();
        return response()->json($risks);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['description' => 'required|string|max:400']);
        $risk = Risk::create(['description' => $request->input('description')]);
        return response()->json(['message' => 'Risk created successfully', 'risk' => $risk], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $risk = Risk::find($id);
        if (!$risk) {
            return response()->json(['message' => 'Risk not found'], 404);
        }
        return response()->json($risk);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'description' => 'required|string|max:400',
        ]);

        $risk = Risk::find($id);

        if (!$risk) {
            return response()->json(['message' => 'Risk not found'], 404);
        }

        $risk->update([
            'description' => $request->description,
        ]);

        return response()->json(['message' => 'Risk updated successfully', 'risk' => $risk]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $risk = Risk::find($id);

        if (!$risk) {
            return response()->json(['message' => 'Risk not found'], 404);
        }

        $risk->delete();

        return response()->json(['message' => 'Risk deleted successfully']);
    }
}
