<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\OperationalControl;
use App\Http\Controllers\Controller;

class OperationalControlController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $operationalControls = OperationalControl::with('iperc', 'iperc.place', 'iperc.process', 'iperc.task', 'iperc.workPosition', 'iperc.risk', 'iperc.danger', 'iperc.consequence', 'iperc.risk.riskEvaluation')->get();
        return response()->json($operationalControls);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        // Validar los datos recibidos en la solicitud
        $request->validate([
            'iperc_id' => 'required|exists:iperc,id',
            'elimination' => 'required|string',
            'sustitution' => 'required|string',
            'engineering_control' => 'required|string',
            'admin_control' => 'required|string',
            'epps' => 'required|string',
        ]);

        // Crear un nuevo registro en la tabla 'operational_control' usando los datos del cuerpo de la solicitud
        $operationalControl = OperationalControl::create([
            'iperc_id' => $request->iperc_id,
            'elimination' => $request->elimination,
            'sustitution' => $request->sustitution,
            'engineering_control' => $request->engineering_control,
            'admin_control' => $request->admin_control,
            'epps' => $request->epps,
        ]);

        // Retornar una respuesta indicando que el registro fue creado exitosamente
        return response()->json(['message' => 'Operational Control created successfully', 'operational_control' => $operationalControl], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $operationalControl = OperationalControl::find($id);
        if (!$operationalControl) {
            return response()->json(['message' => 'Operational Control not found'], 404);
        }
        return response()->json($operationalControl);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        // Validar los datos recibidos en la solicitud
        $request->validate([
            'iperc_id' => 'required|exists:iperc,id',
            'elimination' => 'required|string',
            'sustitution' => 'required|string',
            'engineering_control' => 'required|string',
            'admin_control' => 'required|string',
            'epps' => 'required|string',
        ]);

        // Buscar el registro a actualizar
        $operationalControl = OperationalControl::find($id);

        // Verificar si el registro existe
        if (!$operationalControl) {
            return response()->json(['message' => 'Operational Control not found'], 404);
        }

        // Actualizar los datos del registro
        $operationalControl->update([
            'iperc_id' => $request->iperc_id,
            'elimination' => $request->elimination,
            'sustitution' => $request->sustitution,
            'engineering_control' => $request->engineering_control,
            'admin_control' => $request->admin_control,
            'epps' => $request->epps,
        ]);

        // Retornar una respuesta indicando que el registro fue actualizado exitosamente
        return response()->json(['message' => 'Operational Control updated successfully', 'operational_control' => $operationalControl]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        // Buscar el registro a eliminar
        $operationalControl = OperationalControl::find($id);

        // Verificar si el registro existe
        if (!$operationalControl) {
            return response()->json(['message' => 'Operational Control not found'], 404);
        }

        // Eliminar el registro
        $operationalControl->delete();

        // Retornar una respuesta indicando que el registro fue eliminado exitosamente
        return response()->json(['message' => 'Operational Control deleted successfully']);

    }

}
