<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class BannerController extends Controller
{
    public function create(){
        return view('content.banners.create');
    }

    public function list(){
        $banners = Banner::all();
        return $banners;
    }

    public function store(Request $request){
        $banner = new Banner();
        $banner->name = $request->name;
        $banner->description = $request->description;
        $banner->status = 0;
        if($request->hasFile('file')){
            $file = $request->file('file');
            $banner_name = Helper::formatFilename($file->getClientOriginalName());
            $path = 'pub_images/';
            Storage::disk('s3')->put($path.$banner_name, file_get_contents($file), 'public');
            $banner->filename = $banner_name;
            $banner->path = $path.$banner_name;
        }
        $banner->save();
    }

    public function update(Request $request){
        $banner = Banner::findOrFail($request->id);
        $banner->name = $request->name;
        $banner->description = $request->description;
        if($request->hasFile('file')){
            $file = $request->file('file');
            $banner_name = Helper::formatFilename($file->getClientOriginalName());
            $path = 'pub_images/';
            if(Storage::disk('s3')->has($path.$banner_name)){
                Storage::disk('s3')->delete($path.$banner_name);
            }
            Storage::disk('s3')->put($path.$banner_name, file_get_contents($file), 'public');
            $banner->filename = $banner_name;
            $banner->path = $path.$banner_name;
        }
        $banner->update();
    }

    public function changeStatus($id){
        $banner = Banner::findOrFail($id);
        if($banner->status == 1){
            $banner->status = 0;
            $message = "Se ha ocultado el banner";
        }else{
            $banner->status = 1;
            $message = "El banner es visible para los usuarios";
        }
        $banner->update();

        return $message;
    }
}
