<?php

namespace App\Http\Controllers;

use App\Models\Alert;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AlertController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('alerts');
    }


    public function index()
    {
        return view('content.alert.index');
    }

    /**
     * Idea de mejora
     * guardar un rango de fechas en el cual se presentara la alerta, y otro campo el deadline
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $alert = new Alert();
            $alert->title = $request->title;
            $alert->description = $request->description;
            $alert->deadline = $request->deadline;
            $alert->link = $request->link;
            $alert->status = false;
            if ($alert->save()) {
                DB::commit();
                return response()->json(['success' => 'Alerta creada correctamente']);
            } else {
                DB::rollBack();
                return response()->json(['error' => 'Error al crear la alerta']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function active(Request $request)
    {
    }

    public function list()
    {
        $alerts = Alert::all();
        return response()->json($alerts);
    }
}
