<?php

namespace App\Exports;

use App\Models\Matrix;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;

class MaxtrixExport implements FromQuery, WithMapping, WithHeadings, ShouldQueue, WithTitle
{

    use Exportable;

    protected $id;

    public function __construct($id)
    {
        $this->id = $id;
    }

    public function query()
    {
        return Matrix::query()->with([
            'iperc',
            'iperc.place',
            'iperc.process',
            'iperc.task',
            'iperc.workPosition',
            'iperc.risk',
            'iperc.danger',
            'iperc.consequence',
            'iperc.risk.riskEvaluation',
            'iperc.operationalControls'
        ])->where('id', $this->id);
    }

    public function headings(): array
    {

        return [
            ['N°', 'Proceso', 'Tarea', 'Posición de trabajo', 'Lugar', 'Rutinario', 'Peligro', 'Tipo', 'Riesgo', 'Consecuencias', 'Índice de Personas Expuestas (A)', 'Índice de Procedimientos Existentes (B)', 'Índice de Capacitación (C)', 'Índice de Exposición al Riesgo (D)', 'Índice de Probabilidad de Ocurrencia (A+B+C+D)', 'Índice de Severidad (IS)', 'Probabilidad x Severidad (P x S)', 'Nivel de Riesgo (NV)', 'Riesgo Significativo (RS)', 'Eliminación', 'Sustitución', 'Control de Ingeniería', 'Control Administrativo', 'EPPS', 'Índice de Personas Expuestas (A)', 'Índice de Procedimientos Existentes (B)', 'Índice de Capacitación (C)', 'Índice de Exposición al Riesgo (D)', 'Índice de Probabilidad de Ocurrencia (A+B+C+D)', 'Índice de Severidad (IS)', 'Probabilidad x Severidad (P x S)', 'Nivel de Riesgo (NV)'],
        ];
    }

    public function title(): string
    {
        return "Matriz IPERC";
    }


    public function map($item): array
    {
        $result = [];
        $index = 1;
        foreach ($item->iperc as $iperc) {
            $result[] = [
                'index' => $index,
                'Proceso' => $iperc->process->name,
                'Tarea' => $iperc->task->description,
                'Posición de trabajo' => $iperc->workPosition->name,
                'Lugar' => $iperc->place->name,
                'Rutinario' => $iperc->routine === 'Y' ? 'Rutinario' : 'No Rutinario',
                'Peligro' => $iperc->danger->description,
                'Tipo' => $iperc->type,
                'Riesgo' => $iperc->risk->description,
                'Consecuencias' => $iperc->consequence->description,
                'Índice de Personas Expuestas (A) R' => $iperc->risk->riskEvaluation[0]->index_a,
                'Índice de Procedimientos Existentes (B) R' => $iperc->risk->riskEvaluation[0]->index_b,
                'Índice de Capacitación (C) R' => $iperc->risk->riskEvaluation[0]->index_c,
                'Índice de Exposición al Riesgo (D) R' => $iperc->risk->riskEvaluation[0]->index_d,
                'Índice de Probabilidad de Ocurrencia (A+B+C+D) R' => $iperc->risk->riskEvaluation[0]->probability,
                'Índice de Severidad (IS) R' => $iperc->risk->riskEvaluation[0]->severity,
                'Probabilidad x Severidad (P x S) R' => $iperc->risk->riskEvaluation[0]->ps,
                'Nivel de Riesgo (NV) R' => $iperc->risk->riskEvaluation[0]->NV,
                'Riesgo Significativo (RS)' => $iperc->risk->riskEvaluation[0]->signification === 1 ? 'Sí' : 'No',
                'Eliminación' => $iperc->operationalControls[0]->elimination,
                'Sustitución' => $iperc->operationalControls[0]->sustitution,
                'Control de Ingeniería' => $iperc->operationalControls[0]->engineering_control,
                'Control Administrativo' => $iperc->operationalControls[0]->admin_control,
                'EPPS' => $iperc->operationalControls[0]->epps,
                'Índice de Personas Expuestas (A)' => $iperc->risk->riskEvaluation[1]->index_a,
                'Índice de Procedimientos Existentes (B)' => $iperc->risk->riskEvaluation[1]->index_b,
                'Índice de Capacitación (C)' => $iperc->risk->riskEvaluation[1]->index_c,
                'Índice de Exposición al Riesgo (D)' => $iperc->risk->riskEvaluation[1]->index_d,
                'Índice de Probabilidad de Ocurrencia (A+B+C+D)' => $iperc->risk->riskEvaluation[1]->probability,
                'Índice de Severidad (IS)' => $iperc->risk->riskEvaluation[1]->severity,
                'Probabilidad x Severidad (P x S)' => $iperc->risk->riskEvaluation[1]->ps,
                'Nivel de Riesgo (NV)' => $iperc->risk->riskEvaluation[1]->NV,
            ];
            $index++;
        }

        return $result;

    }
    /*
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->mergeCells('B1:J1');
                $event->sheet->mergeCells('K1:S1');
                $event->sheet->mergeCells('T1:X1');
                $event->sheet->mergeCells('Y1:AF1');
            },
        ];
    }*/


}
