<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Producto;
use Illuminate\Support\Str;

class ProductoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $productos = array(
            array('nombre' => 'Prevencionista en Seguridad y Salud en el Trabajo', 'precio' => '520', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '',   'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Prevencionista en Seguridad y Salud en el Trabajo, Sector Construcción.', 'precio' => '510', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor en Trabajos de Alto Riesgo', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor en Trabajos en Altura', 'precio' => '420', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor en SGSST/ISO 45001:2018', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor SSOMA', 'precio' => '850', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor SSOMA en Minería', 'precio' => '650', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'ISO/PAS 45005:2020', 'precio' => '360', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor en Trabajos en Andamios', 'precio' => '510', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Primeros Auxilios', 'precio' => '360', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'MATPEL I, II y III', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Gestión de Riesgos/ISO 31001', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1',),
            array('nombre' => 'Sistema de Gestión Ambiental/ISO 14001:2015', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Sistema de Gestión de Calidad/ISO 9001:2015', 'precio' => '420', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Supervisor en Seguridad y Salud en el Trabajo, sector Minería', 'precio' => '510', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Trabajos en Espacios Confinados', 'precio' => '360', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Ergonomía Ocupacional', 'precio' => '510', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Higiene Industrial', 'precio' => '510', 'tipo_producto_id' => '1', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Sistemas Integrados de Gestión/ISO 45001, 14001 y 9001', 'precio' => '1250', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Lucha Contra Incendios', 'precio' => '180', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Uso de Extintores', 'precio' => '180', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1'),
            array('nombre' => 'Gestión Integral de Residuos Sólidos', 'precio' => '360', 'tipo_producto_id' => '2', 'descripcion' => '', 'objetivo' => '', 'portada_name' => '', 'portada_url' => '', 'estado_publicacion' => '0', 'course_categories_id' => '1')
        );

        function getText()
        {
            $permitted_chars = "abcdefghijklmnopqrstuvwxyz";
            $text = substr(str_shuffle($permitted_chars), 0, 40);
            return $text;
        }
        foreach ($productos as $prod) {
            $product = new Producto();
            $product->nombre = $prod['nombre'];
            $product->precio = $prod['precio'];
            $product->tipo_producto_id = $prod['tipo_producto_id'];
            $product->slug = Str::slug($prod['nombre']);
            $product->descripcion = getText();
            $product->objetivo = getText();
            $product->portada_name = $prod['portada_name'];
            $product->portada_url = $prod['portada_url'];
            $product->estado_publicacion = $prod['estado_publicacion'];
            $product->course_categories_id = $prod['course_categories_id'];
            $product->will_learn = getText();
            $product->prev_knowledge = getText();
            $product->course_for = getText();
            $product->created_at = now();
            $product->updated_at = now();
            $product->save();
        }
    }
}
