<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserExamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_exams', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('course_id')->unsigned();
            $table->bigInteger('user_id')->unsigned();
            $table->bigInteger('exam_type_id')->unsigned()->nullable();

            $table->double('exam_note')->nullable();
            $table->timestamps();

            $table->foreign('course_id')->references('id')->on('productos');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('exam_type_id')->references('id')->on('exam_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_exams');
    }
}
