<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCourseGamesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('course_games', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('game_type_id');
            $table->unsignedBigInteger('course_id')->nullable();
            $table->unsignedBigInteger('module_id')->nullable();
            $table->unsignedBigInteger('class_id')->nullable();
            $table->string('name',100);
            $table->json('data')->nullable();
            $table->tinyInteger('status')->default(0);
            $table->timestamps();
            
            $table->foreign('game_type_id')->references('id')->on('game_types')
                ->onDelete('cascade');
            $table->foreign('course_id')->references('id')->on('productos')
                ->onDelete('cascade');
            $table->foreign('module_id')->references('id')->on('modules')
                ->onDelete('cascade');
            $table->foreign('class_id')->references('id')->on('class')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('course_games');
    }
}
