<?php

namespace Database\Factories;

use App\Models\Producto;
use App\Models\TipoProducto;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductoFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Producto::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $title = $this->faker->sentence;
        $slug = Str::slug($title, '-');

        return [
            'nombre' => $title,
            'slug' => $slug,
            'descripcion' => $this->faker->sentence(),
            'objetivo' => $this->faker->sentence(),
            'precio' => $this->faker->randomFloat(2, 0, 1000),
            'portada_name' => $this->faker->sentence(),
            'portada_url' => $this->faker->sentence(),
            'estado_publicacion' => 0,
            'tipo_producto_id' => TipoProducto::inRandomOrder()->first()->id,
        ];
    }
}
