<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EmailRecoveryMailable extends Mailable
{
    use Queueable, SerializesModels;

    public $subject = 'Recuperar la contraseña';
    public $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(env('MAIL_USERNAME'), 'IPSSOMA org')
                ->subject('Recuperar la contraseña')
                ->view('emails.email_recovery');
    }
}
