<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
// use App\Helpers\Helper;
// use App\Models\Alert;
use App\Models\News;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

// use App\Models\NewsTagDetail;
// use Illuminate\Http\Request;
// use Illuminate\Support\Facades\DB;
// use Illuminate\Support\Str;
// use Illuminate\Support\Facades\Storage;

class NewsController extends Controller
{
    public function all()
    {
        $news = News::select('id', 'title', 'thumbnail', 'slug', 'description', 'views')
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->get();
        return response()->json($news);
    }

    public function random()
    {
        $news = News::with(['author:id,name'])->where('status', 1)->inRandomOrder()->limit(3)->get();
        return response()->json($news);
    }

    public function searchBySlug($slug)
    {
        $news = News::where('slug', $slug)->with(['author', 'tags'])->first();
        return response()->json($news);
    }

    public function incrementView(Request $request)
    {
        try {
            DB::beginTransaction();
            $news = News::where('slug', $request->slug)->first();
            $news->views = $news->views + 1;
            if ($news->save()) {
                DB::commit();
                return response()->json(['success' => 'visualización incrementada correctamente']);
            } else {
                DB::rollBack();
                return response()->json(['error' => 'visualización no incrementada']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
}
