<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ClientesCertificados;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Org_Heigl\Ghostscript\Ghostscript;
use Spatie\PdfToImage\Pdf;

class GenerarController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('Certificados');
    }


    public function generarCertificado($id)
    {
        $Cliente = ClientesCertificados::findOrFail($id);
        $nombres = $Cliente->nombres;
        $nombres = str_replace(" ", "-", $nombres);
        $apelllidos = $Cliente->apellidos;
        $apelllidos = str_replace(" ", "-", $apelllidos);
        $codigo = $Cliente->codigo_certificado;
        $codigo = str_replace(" ", "-", $codigo);

        $data = compact('Cliente');
        $pdf = 'PDF'::loadView('layouts.plantillaCertificado', $data)->setPaper("letter", "landscape");

        $pdf_name_file = $nombres . '_' . $apelllidos . "_" . $codigo;
        $pdf_file = storage_path('app') . "/pdf_certificado/" . $pdf_name_file . ".pdf";

        $pdf->save($pdf_file);

        return $this->saveImgCertificado($pdf_name_file);
    }

    public function saveImgCertificado($pdf_name_file)
    {
        $pdf_file = storage_path('app') . "/pdf_certificado/" . $pdf_name_file . ".pdf";
        // $img_file = storage_path('app')."/public/img_certificado/".$pdf_name_file.".jpg";
        $img_file = "storage/img_certificado/" . $pdf_name_file . ".jpg";

        Ghostscript::setGsPath();

        $pdf = new Pdf($pdf_file);
        $pdf->saveImage($img_file);

        //eliminado el pdf certificado
        unlink($pdf_file);

        // $path = Storage::disk('local')->path("/public/img_certificado/".$pdf_name_file.".jpg");
        // $path = "storage/img_certificado/" . $pdf_name_file . ".jpg";
        // return response()->download($path, $pdf_name_file . ".jpg");
    }
}
