<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Matrix;
use App\Exports\MaxtrixExport;
use Maatwebsite\Excel\Facades\Excel;
use PDF;
use App\Http\Controllers\Controller;

class MatrixController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $matrixes = Matrix::all();
        return response()->json($matrixes);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'corporation' => 'required|string|max:400',
            'ruc' => 'required|string|size:11',
        ]);

        // Crear un nuevo registro en la tabla 'matrix' usando los datos del cuerpo de la solicitud
        $matrix = Matrix::create([
            'corporation' => $request->corporation,
            'ruc' => $request->ruc,
        ]);

        // Retornar una respuesta indicando que el registro fue creado exitosamente
        return response()->json(['message' => 'Matrix created successfully', 'matrix' => $matrix], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $matrix = Matrix::with([
            'iperc',
            'iperc.place',
            'iperc.process',
            'iperc.task',
            'iperc.workPosition',
            'iperc.risk',
            'iperc.danger',
            'iperc.consequence',
            'iperc.risk.riskEvaluation',
            'iperc.operationalControls'
        ])->find($id);
        if (!$matrix) {
            return response()->json(['message' => 'Matrix not found'], 404);
        }
        return response()->json($matrix);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'corporation' => 'required|string|max:400',
            'ruc' => 'required|string|size:11',
        ]);

        $matrix = Matrix::find($id);

        if (!$matrix) {
            return response()->json(['message' => 'Matrix not found'], 404);
        }

        $matrix->update([
            'corporation' => $request->corporation,
            'ruc' => $request->ruc,
        ]);

        return response()->json(['message' => 'Danger updated successfully', 'danger' => $danger]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
    }

    public function exportarExcel($id)
    {

        $exportador = new MaxtrixExport($id);
        $hoy = date('dmYhis');
        return Excel::download($exportador, "matrix_".$hoy."_iperc.xlsx");
    }

    public function exportarPDF($id)
    {
        $matrix = Matrix::with([
            'iperc',
            'iperc.place',
            'iperc.process',
            'iperc.task',
            'iperc.workPosition',
            'iperc.risk',
            'iperc.danger',
            'iperc.consequence',
            'iperc.risk.riskEvaluation',
            'iperc.operationalControls'
        ])->find($id);

        $pdf = PDF::loadView('matrix/pdf', compact('matrix'))->setPaper('a1', 'landscape');
        // Muestra el PDF en el navegador
        return $pdf->download("matrix_iperc.pdf");
    }
}
