<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\IPERC;
use App\Http\Controllers\Controller;

class IPERCController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $ipercs = IPERC::with('place', 'process', 'task', 'workPosition', 'risk', 'danger', 'consequence', 'risk.riskEvaluation')->get();
        return response()->json($ipercs);
    }

    public function getAllData($id)
    {
        $iperc = IPERC::with('place', 'process', 'task', 'workPosition', 'risk', 'danger','consequence', 'risk.riskEvaluation')->find($id);

        if (!$iperc) {
            return response()->json(['message' => 'IPERC not found'], 404);
        }

        $data = [
            'risk' => $iperc->risk->description,
            'iperc_type' => $iperc->type,
            'iperc_routine' => $iperc->routine,
            'place' => $iperc->place->name,
            'process' => $iperc->process->name,
            'task' => $iperc->task->description,
            'work_position' => $iperc->workPosition->name,
            'danger' => $iperc->danger->description,
            'consequence' => $iperc->consequence->description,
            'risk_evaluation' => $iperc->risk->riskEvaluation,
        ];

        return response()->json($data);
    }

    public function envia($param)
    {
        try {
            $messages = [
                [
                    "role" => "user",
                    "content" => $param
                ]
            ];
            $apiKey = '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';

            $data = [
                "model" => "gpt-3.5-turbo",
                'messages' => $messages,
                'temperature' => 0.7,
                'max_tokens' => 700,
                'n' => 1,
                'stop' => ['\n']
            ];

            $ch = curl_init('https://api.openai.com/v1/chat/completions');
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $apiKey
            ));

            $response = curl_exec($ch);
            $responseArr = json_decode($response, true);

            if (isset($responseArr['choices']) && is_array($responseArr['choices']) && count($responseArr['choices']) > 0) {
                $data = $responseArr;
            } else {
                $data = $responseArr;
            }

            return $data;

        } catch (\Throwable $th) {
            // Registrar el error
            Log::info("Ocurrió un error al consultar", [$th->getMessage()]);
        }
    }

    public function getRecommendation($id)
    {
        $data = $this->getAllData($id);
        $prompt = "Analizar las siguientes variables para hacer sugerencias de control bajo el esquema SSOMA. Toma en cuenta que la sugerencia
        por lo menos debe incluir una estructura json: { elimination , sustitution, engineering_control , admin_control, epps }.\n\n".
            "Nombre del proceso: " . $data['process'] . "\n\n" .
            "Actividad asociada: " . $data['task'] . "\n\n" .
            "Lugar de la actividad: " . $data['place'] . "\n\n" .
            "Posición de trabajo encargada: " . $data['work_position'] . "\n\n" .
            "Peligro asociado: " . $data['danger'] . "\n\n" .
            "Riesgo asociado: " . $data['risk'] . "\n\n" .
            "Consecuencia asociado: " . $data['consequence'] . "\n\n" .
            "Es rutinario: " . ($data['iperc_routine'] == 'Y' ? 'Sí' : 'No') . "\n\n" .
            "Tipo de riesgo: " . $data['risk_evaluation'][0]['type'] . "\n\n" .
            "Probabilidad: " . $data['risk_evaluation'][0]['probability'] . "\n\n" .
            "Severidad: " . $data['risk_evaluation'][0]['severity'] . "\n\n" .
            "Es significativo?: " . ($data['risk_evaluation'][0]['signification'] == 1 ? 'Sí' : 'No') . "\n\n" .
            "json=";

        $response = $this->envia($prompt);

        $content = $response['choices'][0]['message']['content'];
        return response()->json($content);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        // Validar los datos recibidos en la solicitud
        $request->validate([
            'matrix_id' => 'required|exists:matrix,id',
            'places_id' => 'required|exists:places,id',
            'processes_id' => 'required|exists:processes,id',
            'tasks_id' => 'required|exists:tasks,id',
            'work_positions_id' => 'required|exists:work_positions,id',
            'risks_id' => 'required|exists:risks,id',
            'dangers_id' => 'required|exists:dangers,id',
            'consequences_id' => 'required|exists:consequences,id',
            'type' => 'required|string|max:60',
            'routine' => 'required|in:Y,N',
        ]);

        // Crear un nuevo registro en la tabla 'iperc' usando los datos del cuerpo de la solicitud
        $iperc = Iperc::create([
            'matrix_id' => $request->matrix_id,
            'places_id' => $request->places_id,
            'processes_id' => $request->processes_id,
            'tasks_id' => $request->tasks_id,
            'work_positions_id' => $request->work_positions_id,
            'risks_id' => $request->risks_id,
            'dangers_id' => $request->dangers_id,
            'consequences_id' => $request->consequences_id,
            'type' => $request->type,
            'routine' => $request->routine,
        ]);

        // Retornar una respuesta indicando que el registro fue creado exitosamente
        return response()->json(['message' => 'Iperc created successfully', 'iperc' => $iperc], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $iperc = IPERC::find($id);
        if (!$iperc) {
            return response()->json(['message' => 'Iperc not found'], 404);
        }
        return response()->json($iperc);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        // Validar los datos recibidos en la solicitud
        $request->validate([
            'matrix_id' => 'required|exists:matrix,id',
            'places_id' => 'required|exists:places,id',
            'processes_id' => 'required|exists:processes,id',
            'tasks_id' => 'required|exists:tasks,id',
            'work_positions_id' => 'required|exists:work_positions,id',
            'risks_id' => 'required|exists:risks,id',
            'dangers_id' => 'required|exists:dangers,id',
            'consequences_id' => 'required|exists:consequences,id',
            'type' => 'required|string|max:60',
            'routine' => 'required|in:Y,N',
        ]);

        // Buscar el registro a actualizar
        $iperc = IPERC::find($id);

        // Verificar si el registro existe
        if (!$iperc) {
            return response()->json(['message' => 'Iperc not found'], 404);
        }

        // Actualizar los datos del registro
        $iperc->update([
            'matrix_id' => $request->matrix_id,
            'places_id' => $request->places_id,
            'processes_id' => $request->processes_id,
            'tasks_id' => $request->tasks_id,
            'work_positions_id' => $request->work_positions_id,
            'risks_id' => $request->risks_id,
            'dangers_id' => $request->dangers_id,
            'consequences_id' => $request->consequences_id,
            'type' => $request->type,
            'routine' => $request->routine,
        ]);

        // Retornar una respuesta indicando que el registro fue actualizado exitosamente
        return response()->json(['message' => 'Iperc updated successfully', 'iperc' => $iperc]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        // Buscar el registro a eliminar
        $iperc = IPERC::find($id);

        // Verificar si el registro existe
        if (!$iperc) {
            return response()->json(['message' => 'Iperc not found'], 404);
        }

        // Eliminar el registro
        $iperc->delete();

        // Retornar una respuesta indicando que el registro fue eliminado exitosamente
        return response()->json(['message' => 'Iperc deleted successfully']);
    }
}
