"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Theme = void 0;

var _service = require("../service");

var ThemeUtils = _interopRequireWildcard(require("./utils"));

var _helpers = require("../../util/helpers");

var _vue = _interopRequireDefault(require("vue"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Theme = /*#__PURE__*/function (_Service) {
  _inherits(Theme, _Service);

  var _super = _createSuper(Theme);

  function Theme(preset) {
    var _this;

    _classCallCheck(this, Theme);

    _this = _super.call(this);
    _this.disabled = false;
    _this.isDark = null;
    _this.unwatch = null;
    _this.vueMeta = null;
    var _preset$Theme$propert = preset[Theme.property],
        dark = _preset$Theme$propert.dark,
        disable = _preset$Theme$propert.disable,
        options = _preset$Theme$propert.options,
        themes = _preset$Theme$propert.themes;
    _this.dark = Boolean(dark);
    _this.defaults = _this.themes = themes;
    _this.options = options;

    if (disable) {
      _this.disabled = true;
      return _possibleConstructorReturn(_this);
    }

    _this.themes = {
      dark: _this.fillVariant(themes.dark, true),
      light: _this.fillVariant(themes.light, false)
    };
    return _this;
  } // When setting css, check for element and apply new values

  /* eslint-disable-next-line accessor-pairs */


  _createClass(Theme, [{
    key: "css",
    set: function set(val) {
      if (this.vueMeta) {
        if (this.isVueMeta23) {
          this.applyVueMeta23();
        }

        return;
      }

      this.checkOrCreateStyleElement() && (this.styleEl.innerHTML = val);
    }
  }, {
    key: "dark",
    get: function get() {
      return Boolean(this.isDark);
    } // Apply current theme default
    // only called on client side
    ,
    set: function set(val) {
      var oldDark = this.isDark;
      this.isDark = val; // Only apply theme after dark
      // has already been set before

      oldDark != null && this.applyTheme();
    }
  }, {
    key: "applyTheme",
    value: function applyTheme() {
      if (this.disabled) return this.clearCss();
      this.css = this.generatedStyles;
    }
  }, {
    key: "clearCss",
    value: function clearCss() {
      this.css = '';
    } // Initialize theme for SSR and SPA
    // Attach to ssrContext head or
    // apply new theme to document

  }, {
    key: "init",
    value: function init(root, ssrContext) {
      if (this.disabled) return;
      /* istanbul ignore else */

      if (root.$meta) {
        this.initVueMeta(root);
      } else if (ssrContext) {
        this.initSSR(ssrContext);
      }

      this.initTheme(root);
    } // Allows for you to set target theme

  }, {
    key: "setTheme",
    value: function setTheme(theme, value) {
      this.themes[theme] = Object.assign(this.themes[theme], value);
      this.applyTheme();
    } // Reset theme defaults

  }, {
    key: "resetThemes",
    value: function resetThemes() {
      this.themes.light = Object.assign({}, this.defaults.light);
      this.themes.dark = Object.assign({}, this.defaults.dark);
      this.applyTheme();
    } // Check for existence of style element

  }, {
    key: "checkOrCreateStyleElement",
    value: function checkOrCreateStyleElement() {
      this.styleEl = document.getElementById('vuetify-theme-stylesheet');
      /* istanbul ignore next */

      if (this.styleEl) return true;
      this.genStyleElement(); // If doesn't have it, create it

      return Boolean(this.styleEl);
    }
  }, {
    key: "fillVariant",
    value: function fillVariant() {
      var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var dark = arguments.length > 1 ? arguments[1] : undefined;
      var defaultTheme = this.themes[dark ? 'dark' : 'light'];
      return Object.assign({}, defaultTheme, theme);
    } // Generate the style element
    // if applicable

  }, {
    key: "genStyleElement",
    value: function genStyleElement() {
      /* istanbul ignore if */
      if (typeof document === 'undefined') return;
      /* istanbul ignore next */

      this.styleEl = document.createElement('style');
      this.styleEl.type = 'text/css';
      this.styleEl.id = 'vuetify-theme-stylesheet';

      if (this.options.cspNonce) {
        this.styleEl.setAttribute('nonce', this.options.cspNonce);
      }

      document.head.appendChild(this.styleEl);
    }
  }, {
    key: "initVueMeta",
    value: function initVueMeta(root) {
      var _this2 = this;

      this.vueMeta = root.$meta();

      if (this.isVueMeta23) {
        // vue-meta needs to apply after mounted()
        root.$nextTick(function () {
          _this2.applyVueMeta23();
        });
        return;
      }

      var metaKeyName = typeof this.vueMeta.getOptions === 'function' ? this.vueMeta.getOptions().keyName : 'metaInfo';
      var metaInfo = root.$options[metaKeyName] || {};

      root.$options[metaKeyName] = function () {
        metaInfo.style = metaInfo.style || [];
        var vuetifyStylesheet = metaInfo.style.find(function (s) {
          return s.id === 'vuetify-theme-stylesheet';
        });

        if (!vuetifyStylesheet) {
          metaInfo.style.push({
            cssText: _this2.generatedStyles,
            type: 'text/css',
            id: 'vuetify-theme-stylesheet',
            nonce: (_this2.options || {}).cspNonce
          });
        } else {
          vuetifyStylesheet.cssText = _this2.generatedStyles;
        }

        return metaInfo;
      };
    }
  }, {
    key: "applyVueMeta23",
    value: function applyVueMeta23() {
      var _this$vueMeta$addApp = this.vueMeta.addApp('vuetify'),
          set = _this$vueMeta$addApp.set;

      set({
        style: [{
          cssText: this.generatedStyles,
          type: 'text/css',
          id: 'vuetify-theme-stylesheet',
          nonce: this.options.cspNonce
        }]
      });
    }
  }, {
    key: "initSSR",
    value: function initSSR(ssrContext) {
      // SSR
      var nonce = this.options.cspNonce ? " nonce=\"".concat(this.options.cspNonce, "\"") : '';
      ssrContext.head = ssrContext.head || '';
      ssrContext.head += "<style type=\"text/css\" id=\"vuetify-theme-stylesheet\"".concat(nonce, ">").concat(this.generatedStyles, "</style>");
    }
  }, {
    key: "initTheme",
    value: function initTheme(root) {
      var _this3 = this;

      // Only watch for reactivity on client side
      if (typeof document === 'undefined') return; // If we get here somehow, ensure
      // existing instance is removed

      if (this.unwatch) {
        this.unwatch();
        this.unwatch = null;
      } // TODO: Update to use RFC if merged
      // https://github.com/vuejs/rfcs/blob/advanced-reactivity-api/active-rfcs/0000-advanced-reactivity-api.md


      root.$once('hook:created', function () {
        var obs = _vue.default.observable({
          themes: _this3.themes
        });

        _this3.unwatch = root.$watch(function () {
          return obs.themes;
        }, function () {
          return _this3.applyTheme();
        }, {
          deep: true
        });
      });
      this.applyTheme();
    }
  }, {
    key: "currentTheme",
    get: function get() {
      var target = this.dark ? 'dark' : 'light';
      return this.themes[target];
    }
  }, {
    key: "generatedStyles",
    get: function get() {
      var theme = this.parsedTheme;
      /* istanbul ignore next */

      var options = this.options || {};
      var css;

      if (options.themeCache != null) {
        css = options.themeCache.get(theme);
        /* istanbul ignore if */

        if (css != null) return css;
      }

      css = ThemeUtils.genStyles(theme, options.customProperties);

      if (options.minifyTheme != null) {
        css = options.minifyTheme(css);
      }

      if (options.themeCache != null) {
        options.themeCache.set(theme, css);
      }

      return css;
    }
  }, {
    key: "parsedTheme",
    get: function get() {
      return ThemeUtils.parse(this.currentTheme || {}, undefined, (0, _helpers.getNestedValue)(this.options, ['variations'], true));
    } // Is using v2.3 of vue-meta
    // https://github.com/nuxt/vue-meta/releases/tag/v2.3.0

  }, {
    key: "isVueMeta23",
    get: function get() {
      return typeof this.vueMeta.addApp === 'function';
    }
  }]);

  return Theme;
}(_service.Service);

exports.Theme = Theme;
Theme.property = 'theme';
//# sourceMappingURL=index.js.map