import toNow from 'date-fns/distance_in_words_to_now';

var defaultConverter = (function (date, locale, converterOptions) {
  var includeSeconds = converterOptions.includeSeconds;
  var addSuffix = converterOptions.addSuffix; if ( addSuffix === void 0 ) addSuffix = true;
  return toNow(date, {
    locale: locale,
    includeSeconds: includeSeconds,
    addSuffix: addSuffix
  });
});

var createTimeago = function (opts) {
  if ( opts === void 0 ) opts = {};

  var locales = opts.locales || {};
  var name = opts.name || 'Timeago';
  return {
    name: name,
    props: {
      datetime: {
        required: true
      },
      title: {
        type: [String, Boolean]
      },
      locale: {
        type: String
      },
      autoUpdate: {
        type: [Number, Boolean]
      },
      converter: {
        type: Function
      },
      converterOptions: {
        type: Object
      }
    },

    data: function data() {
      return {
        timeago: this.getTimeago()
      };
    },

    computed: {
      localeName: function localeName() {
        return this.locale || this.$timeago.locale;
      }

    },

    mounted: function mounted() {
      this.startUpdater();
    },

    beforeDestroy: function beforeDestroy() {
      this.stopUpdater();
    },

    render: function render(h) {
      return h('time', {
        attrs: {
          datetime: new Date(this.datetime).toISOString(),
          title: typeof this.title === 'string' ? this.title : this.title === false ? null : this.timeago
        }
      }, [this.timeago]);
    },

    methods: {
      getTimeago: function getTimeago(datetime) {
        var converter = this.converter || opts.converter || defaultConverter;
        return converter(datetime || this.datetime, locales[this.locale || this.$timeago.locale], this.converterOptions || {});
      },

      convert: function convert(datetime) {
        this.timeago = this.getTimeago(datetime);
      },

      startUpdater: function startUpdater() {
        var this$1 = this;

        if (this.autoUpdate) {
          var autoUpdaye = this.autoUpdate === true ? 60 : this.autoUpdate;
          this.updater = setInterval(function () {
            this$1.convert();
          }, autoUpdaye * 1000);
        }
      },

      stopUpdater: function stopUpdater() {
        if (this.updater) {
          clearInterval(this.updater);
          this.updater = null;
        }
      }

    },
    watch: {
      autoUpdate: function autoUpdate(newValue) {
        this.stopUpdater();

        if (newValue) {
          this.startUpdater();
        }
      },

      datetime: function datetime() {
        this.convert();
      },

      localeName: function localeName() {
        this.convert();
      },

      converter: function converter() {
        this.convert();
      },

      converterOptions: {
        handler: function handler() {
          this.convert();
        },

        deep: true
      }
    }
  };
};
var install = function (Vue, opts) {
  if (Vue.prototype.$timeago) {
    return;
  }

  if (process.env.NODE_ENV === 'development' && !Vue.observable) {
    console.warn("[vue-timeago] Vue 2.6 or above is recommended.");
  }

  var $timeago = {
    locale: opts.locale
  };
  Vue.prototype.$timeago = Vue.observable ? Vue.observable($timeago) : new Vue({
    data: $timeago
  });
  var Component = createTimeago(opts);
  Vue.component(Component.name, Component);
};
var converter = defaultConverter;

export default install;
export { createTimeago, install, converter };
